% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_models}
\alias{plot_models}
\title{Models plot for a RoBMA object}
\usage{
plot_models(
  x,
  parameter = "mu",
  conditional = FALSE,
  output_scale = NULL,
  plot_type = "base",
  order = "decreasing",
  order_by = "model",
  ...
)
}
\arguments{
\item{x}{a fitted RoBMA object}

\item{parameter}{a parameter to be plotted. Defaults to
\code{"mu"} (for the effect size). The additional option
is \code{"tau"} (for the heterogeneity).}

\item{conditional}{whether conditional estimates should be
plotted. Defaults to \code{FALSE} which plots the model-averaged
estimates. Note that both \code{"weightfunction"} and
\code{"PET-PEESE"} are always ignoring the other type of
publication bias adjustment.}

\item{output_scale}{transform the effect sizes and the meta-analytic
effect size estimate to a different scale. Defaults to \code{NULL}
which returns the same scale as the model was estimated on.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{order}{how the models should be ordered.
Defaults to \code{"decreasing"} which orders them in decreasing
order in accordance to \code{order_by} argument. The alternative is
\code{"increasing"}.}

\item{order_by}{what feature should be use to order the models.
Defaults to \code{"model"} which orders the models according to
their number. The alternatives are \code{"estimate"} (for the effect
size estimates), \code{"probability"} (for the posterior model probability),
and \code{"BF"} (for the inclusion Bayes factor).}

\item{...}{list of additional graphical arguments
to be passed to the plotting function. Supported arguments
are \code{lwd}, \code{lty}, \code{col}, \code{col.fill},
\code{xlab}, \code{ylab}, \code{main}, \code{xlim}, \code{ylim}
to adjust the line thickness, line type, line color, fill color,
x-label, y-label, title, x-axis range, and y-axis range
respectively.}
}
\value{
\code{plot_models} returns either \code{NULL} if \code{plot_type = "base"}
or an object object of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
\code{plot_models} plots individual models'
estimates for a \code{"RoBMA"} object.
}
\examples{
\dontrun{
# using the example data from Anderson et al. 2010 and fitting the default model
# (note that the model can take a while to fit)
fit <- RoBMA(r = Anderson2010$r, n = Anderson2010$n, study_names = Anderson2010$labels)

### ggplot2 version of all of the plots can be obtained by adding 'model_type = "ggplot"
# the plot_models function creates a plot for of the individual models' estimates, for example,
# the effect size estimates from the individual models can be obtained with
plot_models(fit)

# and effect size estimates from only the conditional models
plot_models(fit, conditional = TRUE)
}


}
