% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{llogis-aft}
\alias{llogis-aft}
\alias{llogis_aft_log_density}
\alias{llogis_aft_log_hazard}
\alias{llogis_aft_log_survival}
\alias{llogis_aft_density}
\alias{llogis_aft_hazard}
\alias{llogis_aft_survival}
\alias{llogis_aft_mean}
\alias{llogis_aft_sd}
\alias{llogis_aft_r}
\alias{llogis_aft_q}
\alias{llogis_aft_p}
\title{Log-logistic AFT parametric family.}
\usage{
llogis_aft_log_density(t, eta, shape)

llogis_aft_log_hazard(t, eta, shape)

llogis_aft_log_survival(t, eta, shape)

llogis_aft_density(t, eta, shape)

llogis_aft_hazard(t, eta, shape)

llogis_aft_survival(t, eta, shape)

llogis_aft_mean(eta, shape)

llogis_aft_sd(eta, shape)

llogis_aft_r(n, eta, shape)

llogis_aft_q(p, eta, shape)

llogis_aft_p(q, eta, shape)
}
\arguments{
\item{t}{vector of survival times}

\item{eta}{linear predictor}

\item{shape}{auxiliary parameter}

\item{n}{number of observations}

\item{p}{vector of probabilities}

\item{q}{vector of quantiles}
}
\value{
\code{llogis_aft_density}, \code{llogis_aft_hazard}, and
\code{llogis_aft_survival} return the density, hazard, and survival
of the specified survival distribution. The \code{llogis_aft_log_density},
\code{llogis_aft_log_hazard}, \code{llogis_aft_log_survival} return log of
the corresponding qualities. \code{llogis_aft_mean} and \code{llogis_aft_sd}
return the mean and standard deviation of the specified survival distribution.
\code{llogis_aft_r}, \code{llogis_aft_q}, and \code{llogis_aft_p} return a random
generation, quantiles, and cumulative probabilities of the specified
survival distribution.
}
\description{
(log) density, hazard, and survival
functions for AFT log-logistic parametric family.
}
