% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/place_order.R
\name{place_order}
\alias{place_order}
\title{Place a buy or sell order against your RobinHood account}
\usage{
place_order(RH, symbol, type, time_in_force, trigger, price,
  stop_price = NA, quantity, side)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{symbol}{(string) Ticket symbol you are attempting to buy or sell}

\item{type}{(string) "market" or "limit"}

\item{time_in_force}{(string) Good For Day ("gfd"), Good Till Canceled ("gtc"), Immediate or Cancel ("ioc"), or Opening ("opg")}

\item{trigger}{(string) "immediate" or "stop"}

\item{price}{(number) the price you are willing to sell or buy at}

\item{stop_price}{(number) if trigger = stop, enter stop price, otherwise leave blank}

\item{quantity}{(int) number of shares you wish to transact}

\item{side}{(string) "buy" or "sell"}
}
\description{
Place a buy or sell order against your RobinHood account
}
\examples{
\dontrun{
# Login in to your RobinHood account
RH <- RobinHood("username", "password")

# Place an order, should generate an email confirmation
x <- place_order(RH = RH,
                 symbol = "GE",          # Ticker symbol you want to trade
                 type = "market",        # Type of market order (market, limit)
                 time_in_force = "gfd",  # Time period the order is good for (gfd: good for day)
                 trigger = "immediate",  # Trigger or delay order
                 price = 8.96,           # The highest price you are willing to pay
                 quantity = 1,           # Number of shares you want
                 side = "buy")           # buy or sell
}
}
