% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rogue-package.R
\docType{package}
\name{Rogue-package}
\alias{Rogue}
\alias{Rogue-package}
\title{Rogue}
\description{
"Rogue" implements approaches to identify rogue taxa in phylogenetic
analysis.
Rogues are wildcard leaves whose uncertain position, perhaps a result of
missing or conflicting data, reduces the resolution of consensus trees
\insertCite{Kearney2002}{Rogue}.
Consensus trees that omit rogue taxa can be more informative.
}
\details{
"Rogue" allows the user to select a concept of "information" by which the
quality of consensus trees should be evaluated, and a heuristic approach
by which rogue taxa should be identified.

Rogue detection using the phylogenetic and clustering information content
measures (\acronym{SPIC}, \acronym{SCIC}) \insertCite{SmithCons}{Rogue}
is implemented using a quick heuristic that drops
the least "stable" leaves one at a time,
using an \emph{ad hoc} definition of stability \insertCite{SmithCons}{Rogue};
and by a more exhaustive (and time-consuming) approach that considers
dropping all possible sets of up to \emph{n} leaves
\insertCite{Aberer2013}{Rogue}.

The latter heuristic is implemented for the relative bipartition
"information" content and Pattengale's criterion
\emph{via} \href{https://rnr.h-its.org/about}{RogueNaRok} \insertCite{Aberer2013}{Rogue}.
\subsection{Citing 'Rogue'}{

If you find this package useful in your work, Please consider citing
Smith (2021).

To cite the underlying methods, please cite
\insertCite{Aberer2013;textual}{Rogue} ('RogueNaRok')
or \insertCite{SmithCons;textual}{Rogue} (SPIC, SCIC), as appropriate.
}
}
\references{
\insertAllCited{}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ms609/Rogue/}
  \item \url{https://github.com/aberer/RogueNaRok/}
  \item \url{https://github.com/ms609/RogueNaRok/}
  \item Report bugs at \url{https://github.com/ms609/Rogue/issues/}
}

}
\author{
\strong{Maintainer}: Martin R. Smith \email{martin.smith@durham.ac.uk} (\href{https://orcid.org/0000-0001-5660-1727}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Andre J. Aberer \email{andre.aberer@googlemail.com} [copyright holder]
}

}
\keyword{internal}
