% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{TipVolatility}
\alias{TipVolatility}
\title{Detect rogue taxa using phylogenetic information distance}
\usage{
TipVolatility(trees)
}
\arguments{
\item{trees}{List of trees to analyse.}
}
\value{
\code{TipVolatility()} returns a named vector listing the volatility
index calculated for each leaf.
}
\description{
Calculate the volatility of each tip: namely, the impact on the mean
phylogenetic information distance \insertCite{Smith2020}{Rogue} between
trees when that tip is removed.
Effective when the number of trees is small.
}
\examples{
library("TreeTools", quietly = TRUE)
trees <- AddTipEverywhere(BalancedTree(8), 'Rogue')
trees[] <- lapply(trees, AddTip, 'Rogue', 'Rogue2')

sb <- TipVolatility(trees)
sbNorm <- 1 + (99 * (sb - min(sb)) / (max(sb - min(sb))))
col <- hcl.colors(128, 'inferno')[sbNorm]
plot(consensus(trees), tip.color = col)
plot(ConsensusWithout(trees, names(sb[sb == max(sb)])))
}
\references{
\insertAllCited{}
}
\seealso{
Other tip instability functions: 
\code{\link{TipInstability}()}
}
\concept{tip instability functions}
