\name{BC.positive.reg.FRST}
\alias{BC.positive.reg.FRST}
\title{Positive region based on fuzzy rough set}
\usage{
  BC.positive.reg.FRST(decision.table, fuzzyroughset)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{fuzzyroughset}{a \code{"LowerUpperApproximation"}
  class representing a fuzzy rough set that is produced by
  \code{\link{BC.LU.approximation.FRST}}.}
}
\value{
  A class \code{"PositiveRegion"} containing the following
  components: \itemize{ \item \code{positive.freg}: a
  vector representing membership degrees to the fuzzy
  positive region for each index of objects.  \item
  \code{degree.dependency}: a value expressing the degree
  of dependency.  \item \code{type.model}: a string
  representing type of models. In this case, it is
  \code{"FRST"} which means fuzzy rough set theory.  }
}
\description{
  This is a function that implements a fundamental concept
  of fuzzy rough set theory which is the positive region
  and the corresponding degree of dependency. The
  explanation about this concept can be seen in
  \code{\link{B.Introduction-FuzzyRoughSets}}.
}
\details{
  In order to compute the function, we need to calculate
  the indiscernibility relation by executing
  \code{\link{BC.IND.relation.FRST}} and the lower and
  upper approximations by calling
  \code{\link{BC.LU.approximation.FRST}}.
}
\examples{
###########################################################
##### 1. Example: Using simple decision table containing
#####             nominal values for the decision attribute
###########################################################
dt.ex1 <- data.frame(c(-0.4, -0.4, -0.3, 0.3, 0.2, 0.2),
                     c(-0.3, 0.2, -0.4, -0.3, -0.3, 0),
				        c(-0.5, -0.1, -0.3, 0, 0, 0),
				        c("no", "yes", "no", "yes", "yes", "no"))
colnames(dt.ex1) <- c("a", "b", "c", "d")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 4)

## let us consider the first and second attributes only as conditional attribute
condAttr <- c(1, 2)

## let us consider the fourth attribute as decision attribute
decAttr <- c(4)

#### Calculate fuzzy indiscernibility relation ####
control.ind <- list(type.aggregation = c("t.tnorm", "lukasiewicz"),
                    type.relation = c("tolerance", "eq.1"))
control.dec <- list(type.aggregation = c("crisp"), type.relation = "crisp")

IND.condAttr <- BC.IND.relation.FRST(decision.table, attributes = condAttr,
                                     control = control.ind)
IND.decAttr <- BC.IND.relation.FRST(decision.table, attributes = decAttr,
                                     control = control.dec)

#### Calculate fuzzy lower and upper approximation using type.LU :
#### "implicator.tnorm"
control <- list(t.implicator = "lukasiewicz")
FRST.LU <- BC.LU.approximation.FRST(decision.table, IND.condAttr, IND.decAttr,
              type.LU = "implicator.tnorm", control = control)

#### Determine positive regions ####
res.1 <- BC.positive.reg.FRST(decision.table, FRST.LU)

###########################################################
##### 2. Example: Using housing decision table containing
#####             continuous values for the decision attribute
###########################################################

## In this case, we are using housing dataset containing 7 objects
data(RoughSetData)
decision.table <- RoughSetData$housing7.dt

conditional.attr <- c(1, 2)
decision.attr = c(14)
control.ind <- list(type.aggregation = c("t.tnorm", "lukasiewicz"),
                     type.relation = c("tolerance", "eq.1"))

#### Calculate fuzzy indiscernibility relation ####
IND.condAttr <- BC.IND.relation.FRST(decision.table, attributes = conditional.attr,
                                     control = control.ind)
IND.decAttr <- BC.IND.relation.FRST(decision.table, attributes = decision.attr,
                                     control = control.ind)

#### Calculate fuzzy lower and upper approximation using type.LU :
#### "implicator.tnorm"
control <- list(t.implicator = "lukasiewicz", t.tnorm = "lukasiewicz")

FRST.LU <- BC.LU.approximation.FRST(decision.table, IND.condAttr, IND.decAttr,
              type.LU = "implicator.tnorm", control = control)

#### Determine fuzzy regions ####
res.2 <- BC.positive.reg.FRST(decision.table, FRST.LU)
}
\references{
  R. Jensen and Q. Shen, "New Approaches to Fuzzy-Rough
  Feature Selection", IEEE Trans. on Fuzzy Systems, vol.
  19, no. 4, p. 824 - 838 (2009).
}
\seealso{
  \code{\link{BC.LU.approximation.FRST}},
  \code{\link{BC.IND.relation.FRST}},
  \code{\link{BC.IND.relation.RST}},

  \code{\link{BC.LU.approximation.RST}}, and
  \code{\link{BC.positive.reg.FRST}}.
}

