\name{FS.one.reduct.computation}
\alias{FS.one.reduct.computation}
\title{The function for computing one reducts}
\usage{
FS.one.reduct.computation(discernibilityMatrix, greedy = TRUE, power = 2)
}
\arguments{
  \item{discernibilityMatrix}{a
  \code{"DiscernibilityMatrix"} class representing the
  discernibility matrix of RST and FRST.}

  \item{greedy}{a boolean value whether we are using the
  greedy heuristic or a randomized search.}

  \item{power}{a numeric representing a parameter of the
  greedy heuristic.

  See \code{\link{BC.discernibility.mat.RST}} and
  \code{\link{BC.discernibility.mat.FRST}}.}
}
\value{
A class \code{"ReductSet"}.
}
\description{
It is a function for computing one reduct from a
discernibility matrix - it can be the greedy heuristic or a
randomized search.
}
\examples{
########################################################
## Example 1: Generate one reducts and
##            a new decision table using RST
########################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## build the decision-relation discernibility matrix
res.1 <- BC.discernibility.mat.RST(decision.table, range.object = NULL)

## generate all reducts
reduct <- FS.one.reduct.computation(res.1)

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, reduct, control = list(indx.reduct = 1))

##############################################################
## Example 2: Generate one reducts and
##            a new decision table using FRST
##############################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## build the decision-relation discernibility matrix
control <- list(type.relation = c("crisp"),
                type.aggregation = c("crisp"),
                t.implicator = "lukasiewicz", type.LU = "implicator.tnorm")
res.2 <- BC.discernibility.mat.FRST(decision.table, type.discernibility = "standard.red",
                                    control = control)

## generate single reduct
reduct <- FS.one.reduct.computation(res.2)

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, reduct, control = list(indx.reduct = 1))
}

