% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyhedra-lib.R
\docType{class}
\name{PolyhedronStateNetlibScraper.class}
\alias{PolyhedronStateNetlibScraper.class}
\title{Polyhedron State Netlib Scraper}
\format{\code{\link{R6Class}} object.}
\usage{
PolyhedronStateNetlibScraper.class
}
\description{
Scrapes polyhedra from a PHD file format.
}
\section{Fields}{

\describe{
\item{\code{netlib.p3.lines}}{The path to the PHD files}

\item{\code{labels.rows}}{Labels - row of appearance}

\item{\code{labels.map}}{Labels - Map of content}
}}

\section{Methods}{

\describe{
  \item{\code{initialize(number, netlib.p3.lines)}}{Initializes the object, taking the number and PDH file as parameters}
  \item{\code{extract_fows_from_label(label.number, expected.label)}}{Extracts data from the label, taking the label number and the
  expected label as parameters}
  \item{\code{getLabels()}}{Gets the label from the polyhedron}
  \item{\code{scrapeNet(net.txt, offset = 0) }}{Scrape the net model}
  \item{\code{extractCFOutBrackets()}}{Gets the CF Out Brackets}
  \item{\code{scrapeVertices(vertices.txt)}}{Scrapes the vertices}
  \item{\code{setupLabelsOrder()}}{Sets up the order of labels included in PHD file}
  \item{\code{getDataFromLabel(label)}}{Gets data from the Label}
  \item{\code{scrape()}}{Scrapes the data from the PHD file}
  \item{\code{buildRGL(size = 1, origin = c(0, 0, 0), normalize.size = TRUE)}}{Builds the \code{RGL} mmodel}
}
}

\keyword{datasets}
