% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public-lib.R
\name{getAvailablePolyhedra}
\alias{getAvailablePolyhedra}
\title{Get available polyhedra}
\usage{
getAvailablePolyhedra(sources, search.string)
}
\arguments{
\item{sources}{A string vector containing the source, which can be obtained from getAvailableSources().}

\item{search.string}{A search string}
}
\value{
polyhedra names vector
}
\description{
Gets the list of names of available polyhedra and its status in
the polyhedra database, which can be later called with getPolyhedron
}
\examples{

# gets all polyhedra in the database
available.polyhedra <- getAvailablePolyhedra()

# returns all polyhedra from a given source, in this case, netlib
available.netlib.polyhedra <- getAvailablePolyhedra(sources = "netlib")

# search within the polyhedron names

cube <- getAvailablePolyhedra(sources = "netlib", search.string = "cube")
cube
}
\seealso{
getAvailableSources
}
