% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{WOE_customFactor}
\alias{WOE_customFactor}
\title{Custom Binning Factor Variables}
\usage{
WOE_customFactor(dataset, var, target, new_levels, new_labels,
  color = "#0066CC")
}
\arguments{
\item{dataset}{Dataframe containing the target variable and desired factor variables to be binned.}

\item{var}{A specific factor attribute to be binned.}

\item{target}{A binary target variable. Must be specified.}

\item{new_levels}{A vector the same length as the number of levels
for the categorical variable containing the new factor levels.
Must be specified.}

\item{new_labels}{A vector the same length as the number of new factor
levels assigned containing the labels for the new factor levels. If specified, renames \code{new_levels}.}

\item{color}{A hexadecimal value representing a specific color.}
}
\value{
A vector containing the newly binned values.
Generates three barplots displaying the worth of evidence (WoE),
target rate and frequency across all bins.
The bars are arranged in an ascending order of WoE.
}
\description{
Function that bins a factor variable based on user inputted factor levels, plots the information on the new bins, and returns a vector of the newly binned values
}
\examples{
mydata <- ISLR::Default
mydata$default <- ifelse(mydata$default=="Yes", 1, 0) ## target coded with 1, 0
## WOE_customFactor
custom1 <- WOE_customFactor(mydata, var="student", target="default",
                 new_levels=c("Student : No","Student : Yes"))
levels(custom1)
## --------------------------
mydata$balance_cat <- cut(mydata$balance, breaks = c(0,800,1600,2400),
                      labels = c("1", "2", "3"))
custom2 <- WOE_customFactor(mydata, var="balance_cat", target="default",
                   new_levels=c(1,2,3),
                   new_labels=c("bal : low","bal : medium","bal : high" ))
levels(custom2)

}
