% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imp_syrinx.R
\name{imp_syrinx}
\alias{imp_syrinx}
\title{Import 'Syrinx' selections}
\usage{
imp_syrinx(path = NULL, all.data = FALSE, recursive = FALSE, 
exclude = FALSE, hz.to.khz = TRUE, parallel = 1, pb = TRUE)
}
\arguments{
\item{path}{A character string indicating the path of the directory in which to look for the text files. 
If not provided (default) the function searches into the current working directory. Default is \code{NULL}.}

\item{all.data}{Logical. If \code{TRUE} all columns in text files are returned. Default is \code{FALSE}. Note 
that all files should contain exactly the same columns in the same order.}

\item{recursive}{Logical. If \code{TRUE} the listing recurses into sub-directories.}

\item{exclude}{Logical. Controls whether files that cannot be read are ignored (\code{TRUE}). Default is \code{FALSE}.}

\item{hz.to.khz}{Logical. Controls if frequency variables should be converted from  Hz (the unit used by Syrinx) to kHz (the unit used by warbleR and other bioacoustic analysis packages in R). Default if \code{TRUE}. Ignored if all.data is \code{TRUE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
A single data frame with information of the selection files. If all.data argument is set to \code{FALSE} the data 
frame contains the following columns: selec, start, end, and selec.file. If sound.file.col is provided the data frame
will also contain a 'sound.files' column. If all.data is set to \code{TRUE} then all 
columns in selection files are returned.
}
\description{
\code{imp_syrinx} imports 'Syrinx' selection data from many files simultaneously. 
All files must have the same columns.
}
\examples{
\dontrun{
#load data 
data(selection_files)

#save 'Raven' selection tables in the temporary directory 
writeLines(selection_files[[7]], con = file.path(tempdir(), names(selection_files)[7]))

syr.dat <- imp_syrinx(all.data = FALSE)

# View(syr.dat)

#getting all the data
syr.dat <- imp_syrinx(all.data = TRUE)

# View(syr.dat)
}

}
\seealso{
\code{\link{imp_raven}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
