% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rrelperm-package.R
\name{kr2p_ow}
\alias{kr2p_ow}
\title{Generate a matrix of two-phase relative permeability data for the water-oil system using the modified Brooks-Corey model}
\usage{
kr2p_ow(SWCON, SWCRIT, SOIRW, SORW, KRWIRO, KROCW, NW, NOW, NP)
}
\arguments{
\item{SWCON}{connate water saturation, fraction}

\item{SWCRIT}{critical water saturation, fraction}

\item{SOIRW}{irreducible oil saturation, fraction}

\item{SORW}{residual oil saturation, fraction}

\item{KRWIRO}{water relative permeability at irreducible oil}

\item{KROCW}{oil relative permeability at connate water}

\item{NW}{exponent term for calculating krw}

\item{NOW}{exponent term for calculating krow}

\item{NP}{number of saturation points in the table, the maximum acceptable value is 501}
}
\value{
A matrix with water saturation, oil saturation, water relative permeability, and oil relative permeability values, respectively
}
\description{
The 'kr2p_ow()' creates a table of two-phase water and oil relative permeability data for water and oil saturation values between zero and one.
}
\examples{
rel_perm_wo <- kr2p_ow(0.15, 0.2, 0.15, 0.15, 0.4, 1, 3, 2, 101)

}
\references{
\insertRef{Brooks1964}{Rrelperm}
}
