% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saga.R
\name{saga_gis}
\alias{saga_gis}
\title{Initiate a SAGA-GIS geoprocessor object}
\usage{
saga_gis(saga_bin = NULL, grid_caching = FALSE,
  grid_cache_threshold = 100, grid_cache_dir = NULL, cores = NULL,
  opt_lib = NULL, temp_path = NULL)
}
\arguments{
\item{saga_bin}{character, optional. Path to saga_cmd executable. If this
argument is not supplied then an automatic search for the saga_cmd
executable will be performed.}

\item{grid_caching}{logical, optional. Use file caching in saga_cmd
geoprocessing operations for rasters that are too large to fit into memory.}

\item{grid_cache_threshold}{numeric, optional. Threshold (in Mb) before file
caching is activated for loaded raster data.}

\item{grid_cache_dir}{character, optional. Path to directory for temporary
files generated by file caching.}

\item{cores}{numeric. Maximum number of processing cores. Needs to be set to
1 if file caching is activated.}

\item{opt_lib}{character vector. Names of SAGA-GIS libraries. Used to link
only a subset of named SAGA-GIS tool libraries, rather than creating
functions for all available tool libraries.}

\item{temp_path}{character vector, optional. Path to use to store any
temporary files that are generated as data is passed between R and
SAGA-GIS. If not specified, then the system tempdir is used.}
}
\value{
S3 saga object containing a nested list of functions for SAGA-GIS
  libraries and tools.
}
\description{
Dynamically generates functions to all valid SAGA-GIS libraries and tools.
These functions are stored within a saga S3 object as a named list of
functions.
}
\examples{
\dontrun{
# Initialize a saga object
saga <- saga_gis()

# Alternatively intialize a saga object using file caching to handle large
# raster files
saga <- saga_gis(grid_caching = TRUE, grid_cache_threshold = 250, cores = 1)

# Example terrain analysis
# Generate a random DEM
dem <- saga$grid_calculus$random_terrain(radius = 100)

# Use Rsagacmd to calculate the Terrain Ruggedness Index
tri <- saga$ta_morphometry$terrain_ruggedness_index_tri(dem = dem)
plot(tri)

# Optionally run command and do not load result as an R object
saga$ta_morphometry$terrain_ruggedness_index_tri(dem = dem, .intern = FALSE)
}
}
