#' Function generate text that will be parsed into R code
#'
#' Internal variable `args` is derived by capturing the names and values of the
#' calling function. The interval `senv` variable is the SAGA-GIS library
#' settings (generated by `saga_env`) and comes from the environment of when the
#' dynamic function was generated.
#'
#' @param lib A character, name of SAGA-GIS library.
#' @param tool A character, name of SAGA-GIS tool.
#'
#' @return A character, text that is to be parsed into a function definition.
#'
#' @keywords internal
create_function <- function(lib, tool) {
  paste(
    paste0("args = as.list(environment())"),
    paste0("lib = ", deparse(lib)),
    paste0("tool = ", deparse(tool)),
    "
        # remove intern and help from saga args list
        if ('.intern' %in% names(args))
            args = args[-which(names(args) == '.intern')]

        if ('.all_outputs' %in% names(args))
            args = args[-which(names(args) == '.all_outputs')]

        # call the saga geoprocessor
        saga_results = saga_execute(lib, tool, senv, .intern,
                                    .all_outputs, .verbose, args)
        return (saga_results)
        ",
    sep = "\n"
  )
}
