% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saga-gis.R
\name{saga_configure}
\alias{saga_configure}
\title{Generates a custom saga_cmd configuration file}
\usage{
saga_configure(
  senv,
  grid_caching = FALSE,
  grid_cache_threshold = 100,
  grid_cache_dir = NULL,
  cores = NULL,
  saga_vers
)
}
\arguments{
\item{senv}{A saga environment object. Contains the SAGA-GIS environment and
settings.}

\item{grid_caching}{Whether to use file caching. The default is FALSE.}

\item{grid_cache_threshold}{Any number to use as a threshold (in Mb) before
file caching for loaded raster data is activated.}

\item{grid_cache_dir}{Optionally specify a path to the used directory for
temporary files. The default uses `base::tempdir`.}

\item{cores}{An integer specifying the maximum number of processing cores.
Needs to be set to 1 if file caching is activated because file caching in
SAGA-GIS is not thread-safe.}

\item{saga_vers}{A `numeric_version` that specifies the version of SAGA-GIS.
The generation of a saga_cmd configuration file is only valid for versions
> 4.0.0.}
}
\value{
A character that specifies the path to custom saga_cmd initiation
  file.
}
\description{
Creates and edits a saga_cmd configuration file in order to change saga_cmd
settings related to file caching and number of available processor cores.
Intended to be used internally by \code{\link{saga_gis}}
}
