% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdirParsing.R
\name{readLssFile}
\alias{readLssFile}
\title{Parses landings (sales notes)}
\usage{
readLssFile(file, encoding = "Latin-1", guessMax = 1e+05, strict = T)
}
\arguments{
\item{file}{path to file with LSS landings}

\item{encoding}{encoding for 'file', must be accepted by \code{\link[data.table]{fread}}}

\item{guessMax}{deprecated parameter, has no effect.}

\item{strict}{enforce strict adherence to data format.}
}
\value{
data.table with LSS landings
}
\description{
Parses sales notes data from the Norwegian Directorate of Fisheries (FDIR) on the LSS format
}
\details{
The LSS format is a pipe-separated format encoding landings (sales-notes).
 It is provided to IMR on a regular basis from FDIR.
 Column headers are in Norwegian.

 Historically, columns in the landings provided from FDIR has been adapted for each data delivery
 Lately data deliveries has become standardized, but in order to support variants
 adherence to the standardization is not enforced by this function, unless option 'strict' is selected.
 If column names does not match specification, but data is otherwise parse-able, a warning will be issued.
 
 If the parameter 'strict' is not TRUE, data types may be inferred from data.
}
