% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsEvaComputeRLsGEVGPD}
\alias{tsEvaComputeRLsGEVGPD}
\title{tsEvaComputeRLsGEVGPD}
\usage{
tsEvaComputeRLsGEVGPD(nonStationaryEvaParams, RPgoal, timeIndex, trans = NA)
}
\arguments{
\item{nonStationaryEvaParams}{The parameters obtained from a non-stationary
extreme value analysis.}

\item{RPgoal}{The target return period for which the return levels are computed.}

\item{timeIndex}{The index at which the time-varying analysis should be estimated.}

\item{trans}{A character string indicating the transformation to be applied
to the data before fitting the EVD. default value is NA, corresponding
to no transformation. Currently only the "rev" for reverse transformation is
implemented.}
}
\value{
A list containing the following components:
\describe{
\item{\code{Fit}}{A character string indicating whether the EVD could be
fitted to the data ("No fit") or the EVD was successfully fitted to the data ("Fitted").}
\item{\code{ReturnLevels}}{A data frame containing the target
return period (\code{ReturnPeriod}), GEV return level (\code{GEV}), GPD return level (\code{GPD}),
GEV return level error (\code{errGEV}), and GPD return level error (\code{errGPD}) for
the specified time index.}
\item{\code{Params}}{A list containing the GEV and GPD parameters for the
specified time index, including their standard errors.}
}
}
\description{
\code{tsEvaComputeRLsGEVGPD} is a function that calculates the return levels
and their associated errors for a Generalized Extreme Value (GEV)
and Generalized Pareto (GPD) distribution using the parameters obtained
from a non-stationary extreme value analysis.
It supports non-stationary analysis by considering different parameters
for each time index.
}
\seealso{
\code{\link{tsEvaComputeReturnLevelsGEV}}, \code{\link{tsEvaComputeReturnLevelsGPD}}
}
