% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{tsEvaPlotAllRLevelsGPD}
\alias{tsEvaPlotAllRLevelsGPD}
\title{tsEvaPlotAllRLevelsGPD}
\usage{
tsEvaPlotAllRLevelsGPD(
  nonStationaryEvaParams,
  stationaryTransformData,
  rlvmax,
  timeIndex,
  timeStamps,
  tstamps,
  trans,
  ...
)
}
\arguments{
\item{nonStationaryEvaParams}{A list of non-stationary evaluation parameters
containing the GPD distribution parameters (epsilon, sigma, threshold),
time horizon start and end (thStart, thEnd), time horizon in years
(timeHorizonInYears), and number of peaks (nPeaks).}

\item{stationaryTransformData}{The stationary transformed data used for
the analysis.}

\item{rlvmax}{The maximum return level data, including the return periods
(haz.RP) and the actual return levels (QNS).}

\item{timeIndex}{The index of the time step used for analysis.}

\item{timeStamps}{The timestamps corresponding to the time steps in
the analysis.}

\item{tstamps}{The timestamps used for labeling the plot.}

\item{trans}{The transformation used to fit the EVD, either
"ori" (original) or "rev" (reverse).}

\item{...}{Additional optional arguments for customizing the plot.}
}
\value{
A plot object showing the relationship between return periods and
return levels for the GPD distribution at different timest
}
\description{
\code{tsEvaPlotAllRLevelsGPD} is a function that generates a plot of
return levels for a Generalized Pareto Distribution (GPD) based on the
provided parameters and data. The plot showcases the evolving relationship
between return periods and return levels, allowing for visual analysis of
extreme events and their probabilities.
}
\examples{
# Example usage of TsEvaNs function
timeAndSeries <- ArdecheStMartin
#go from six-hourly values to daily max
timeAndSeries <- max_daily_value(timeAndSeries)
#keep only the 20 last years
yrs <- as.integer(format(timeAndSeries$date, "\%Y"))
tokeep <- which(yrs>=2000)
timeAndSeries <- timeAndSeries[tokeep,]
timeWindow <- 5*365 # 5 years
TSEVA_data <- TsEvaNs(timeAndSeries, timeWindow,
                      transfType = 'trendPeaks',tail = 'high')
nonStationaryEvaParams <- TSEVA_data[[1]]
stationaryTransformData <- TSEVA_data[[2]]
peax <- nonStationaryEvaParams[[2]]$parameters$peaks
peaxID <- nonStationaryEvaParams[[2]]$parameters$peakID
timeStamps <- stationaryTransformData$timeStamps
trendPeaks <- stationaryTransformData$trendSeries[peaxID]
stdPeaks <- stationaryTransformData$stdDevSeries[peaxID]
peaksCor <- (peax - trendPeaks) / stdPeaks
nYears <- round(length(timeStamps) / 365.25 )
rlvlmax <- empdis(peaksCor, nYears)
rlvlmax$QNS <- peax[order(peax)]
rlvlmax$Idt <- stationaryTransformData$timeStamps[peaxID][order(peax)]
timeIndex <- 2
tstamps <- "Example Timestamps"
trans <- "ori"
# Call the function with the defined arguments
result <- tsEvaPlotAllRLevelsGPD(
  nonStationaryEvaParams, stationaryTransformData,
  rlvlmax, timeIndex, timeStamps, tstamps,
  trans)
# Plot the result
result
}
\seealso{
\code{\link{tsEvaComputeReturnLevelsGPD}}
}
