% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCRs.R
\name{HCR_escapement}
\alias{HCR_escapement}
\title{Fixed escapement harvest control rule}
\usage{
HCR_escapement(
  Assessment,
  reps = 1,
  OCP_type = "SSB_SSB0",
  OCP_threshold = 0.2,
  Ftarget_type = "FMSY",
  relF_max = 1,
  ...
)
}
\arguments{
\item{Assessment}{An object of class \linkS4class{Assessment} with estimates of
FMSY or UMSY and vulnerable biomass in terminal year.}

\item{reps}{The number of stochastic samples of the TAC recommendation.}

\item{OCP_type}{The type of operational control points (OCPs) for the harvest control rule used to determine 
whether there is fishing. By default, use (\code{"SSB_SSB0"} for spawning depletion. Other biomass OCPs include \code{"SSB_SSBMSY"} for spawning biomass relative to MSY and
\code{"SSB_dSSB0"}, for dynamic depletion (dynamic SSB0 is the historical reconstructed biomass with F = 0).
For F-based OCPs, the terminal year fishing mortality relative F01 or Fmax (using yield-per-recruit) or F-SPR\% (see \code{SPR_OCP} argument) can be used.}

\item{OCP_threshold}{The value of the OCP above which fishing can occur.}

\item{Ftarget_type}{The type of F used for the target fishing mortality rate.}

\item{relF_max}{The relative value of Ftarget if \code{OCP > OCP_treshold}.}

\item{...}{Miscellaneous arguments.}
}
\value{
An object of class \linkS4class{Rec} with the TAC recommendation.
}
\description{
A simple control rule that allows fishing when the operational control point (OCP) is above some threshold.
By default, this function sets the TAC at F = 100\% FMSY when spawning depletion > 0.1.
}
\details{
The catch advice is calculated using the catch equation of the corresponding
assessment. See \code{Assessment@forecast$catch_eq}, a function that returns the catch advice for a specified \code{Ftarget}.
}
\examples{
# create an MP to run in closed-loop MSE (fishes at FMSY when B/B0 > 0.2)
SP_escapement <- make_MP(SP, HCR_escapement)

# The MP which fishes at 75\% of FMSY
SP_escapement75 <- make_MP(SP, HCR_escapement, relF_max = 0.75)

# The MP which fishes at FMSY when BMSY > 0.5
SP_BMSY_escapement <- make_MP(SP, HCR_escapement, OCP_type = "SSB_SSBMSY", 
                              OCP_threshold = 0.5, relF_max = 1)

\donttest{
myOM <- MSEtool::runMSE(MSEtool::testOM, MPs = c("FMSYref", "SP_escapement", "SP_BMSY_escapement"))
}
}
\references{
Deroba, J.J. and Bence, J.R. 2008. A review of harvest policies: Understanding relative
performance of control rules. Fisheries Research 94:210-223.
}
\seealso{
\link{make_MP} \link{HCR_ramp}
}
\author{
Q. Huynh
}
