% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.dOTC.R
\name{dOTC}
\alias{dOTC}
\title{dOTC (dynamical Optimal Transport Correction) method}
\description{
Perform a multivariate (non stationary) bias correction.
}
\details{
Three random variables are needed, Y0, X0 and X1. The dynamic between X0 and
X1 is estimated, and applied to Y0 to estimate Y1. Finally, OTC is used
between X1 and the Y1 estimated.
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period
X1 = XY$X1 ## Biased in projection period

## Bin length
bin_width = c(0.2,0.2)

## Bias correction
## Step 1 : construction of the class dOTC 
dotc = SBCK::dOTC$new( bin_width ) 
## Step 2 : Fit the bias correction model
dotc$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction, Z is a list containing
## corrections
Z = dotc$predict(X1,X0) 
Z$Z0 ## Correction in calibration period
Z$Z1 ## Correction in projection period

}
\references{
Robin, Y., Vrac, M., Naveau, P., Yiou, P.: Multivariate
            stochastic bias corrections with optimal transport, Hydrol. Earth
            Syst. Sci., 23, 773–786, 2019,
            https://doi.org/10.5194/hess-23-773-2019
}
\section{Super class}{
\code{\link[SBCK:OTC]{SBCK::OTC}} -> \code{dOTC}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{dOTC$new()}}
\item \href{#method-fit}{\code{dOTC$fit()}}
\item \href{#method-predict}{\code{dOTC$predict()}}
\item \href{#method-clone}{\code{dOTC$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new dOTC object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dOTC$new(
  bin_width = NULL,
  bin_origin = NULL,
  cov_factor = "std",
  ot = SBCK::OTNetworkSimplex$new()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bin_width}}{[vector or NULL] A vector of lengths of the cells
discretizing R^{numbers of variables}. If NULL, it is estimating
during the fit}

\item{\code{bin_origin}}{[vector or NULL] Coordinate of lower corner of one
cell. If NULL, c(0,...,0) is used}

\item{\code{cov_factor}}{[string or matrix] Covariance factor to correct the
dynamic transferred between X0 and Y0. For string, available
values are "std" and "cholesky"}

\item{\code{ot}}{[OTSolver] Optimal Transport solver, default is the network
simplex}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `dOTC` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dOTC$fit(Y0, X0, X1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\if{latex}{\out{\hypertarget{method-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction

Note: Only the center of the bins associated to the corrected points are
returned, but all corrections of the form:
>> bw = dotc$bin_width / 2
>> n  = base::prod(base::dim(X1))
>> Z1 = dotc$predict(X1)
>> Z1 = Z1 + t(matrix(stats::runif( n = n min = - bw , max = bw ) , ncol = dim(X1)[1] ))
are equivalent for OTC.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dOTC$predict(X1, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL, else return a list containing Z1 and Z0,
                         the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{dOTC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
