% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{is.historical}
\alias{is.historical}
\title{Checks if table contains historical data}
\usage{
is.historical(.data)
}
\arguments{
\item{.data}{A data frame, a tibble, a data.table or a tbl.}
}
\value{
TRUE if .data contains the columns: "checksum", "from_ts", and "until_ts". FALSE otherwise
}
\description{
Checks if table contains historical data
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())

dplyr::copy_to(conn, mtcars, name = id("mtcars", conn))
create_table(mtcars, conn, db_table_id = id("mtcars_historical", conn))

is.historical(get_table(conn, "mtcars")) # FALSE
is.historical(get_table(conn, "mtcars_historical")) # TRUE

close_connection(conn)
}
