% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFits_OLS.R
\name{makeFits_OLS}
\alias{makeFits_OLS}
\title{Prepare results for cosine model fit with proposed initialization.}
\usage{
makeFits_OLS(paths)
}
\arguments{
\item{paths}{A list of data frames, where each frame contains the data for one individual. Every
data frame should have two columns with names 'distance' and 'oxygen'.}
}
\value{
A data frame containing the following components:

\item{amplitude}{estimated amplitude}
\item{intercept}{estimated intercept}
\item{x0}{delay of the data}
\item{X}{period of the data}
\item{birth}{birth seasonality estimate}
\item{predictedMin}{predicted minimum for the oxygen isotope variable}
\item{predictedMax}{predicted maximum for the oxygen isotope variable}
\item{observedMin}{observed minimum for the oxygen isotope variable}
\item{observedMax}{observed minimum for the oxygen isotope variable}
\item{MSE}{mean squared error corresponding to the model fit for every individual}
\item{Pearson}{Pearson's R^2 corresponding to the model fit for every individual}
}
\description{
Performs the nonlinear least squares (NLS) regression method for the cosine
model, with the proposed initialization for all the parameters. It fits the NLS method
as required, and then computes different quantities for the birth seasonality estimates
corresponding to different individuals.
}
\examples{
armenia_split = split(armenia,f = armenia$ID)
makeFits_OLS(armenia_split)
}
