% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDMtab.R
\name{SDMtab}
\alias{SDMtab}
\title{Compile species distribution dataset for modelling}
\usage{
SDMtab(xydata, predictors, unique.data = TRUE, same = TRUE, background.nb=NULL)
}
\arguments{
\item{xydata}{Dataframe with longitude (column 1) and latitude (column 2) of the presence-only data. Decimal longitude and latitude are required.}

\item{predictors}{Rasterstack of environmental descriptors. Used to extract values of the presence location}

\item{unique.data}{If TRUE (by default), duplicate presence points, that fall in the same grid cell, will be removed}

\item{same}{If TRUE (by default), the number of background data sampled in the area equals the number of presence data}

\item{background.nb}{Set as NULL if same= TRUE.}
}
\value{
A dataframe that contains the id (1 for presence, 0 for background data) of data, their longitude, latitude and extracted values of environmental descriptors at the corresponding locations.

xydata for which coordinates fall out of the RasterStack extent are removed from the analysis.
}
\description{
Create a dataframe that contains the required information to implement species distribution models
}
\details{
Background data are sampled randomly (without replacement) among the entire area, on pixels that are not assigned NA. It constitutes a summary of environmental descriptors to improve modelling performance. See Barbet Massin et al. (2012) for further information about background selection.
}
\examples{
#Open occurrence data
data('ctenocidaris.nutrix')
occ <- ctenocidaris.nutrix

#Open environmental descriptors RasterStack
r <- raster:: stack(system.file('extdata', 'pred.grd',package='SDMPlay'))

#create the dataframe for modelling
z <- SDMPlay:::SDMtab(xydata=occ[,c('decimal.Longitude','decimal.Latitude')],predictors=r)
head(z)

}
\references{
Barbet Massin M, F Jiguet, C Albert & W Thuiller (2012) Selecting pseudo absences for species distribution models: how, where and how many? \emph{Methods in Ecology and Evolution}, 3(2): 327-338.
}
\seealso{
\link{delim.area} to refine the environmental RasterStack before using this function
}

