% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confMatrix.R
\name{confMatrix}
\alias{confMatrix}
\title{Confusion Matrix}
\usage{
confMatrix(model, test = NULL, th = NULL, type = NULL)
}
\arguments{
\item{model}{\code{\linkS4class{SDMmodel}} object.}

\item{test}{\code{\linkS4class{SWD}} test locations, if not provided it uses
the train dataset, default is \code{NULL}.}

\item{th}{numeric vector, if provided it computes the evaluation at the given
thresholds, default is \code{NULL} and it computes the evaluation for the
unique predicted values at presence and absence/background locations.}

\item{type}{character. The output type used for "Maxent" and "Maxnet"
methods, possible values are "cloglog" and "logistic", default is
\code{NULL}.}
}
\value{
The Confusion Matrix for all the used thresholds.
}
\description{
Computes Confusion Matrixes for threshold values varying from 0 to 1.
}
\details{
\itemize{
\item For models trained with the \strong{Maxent} method the argument \code{type} can
be: "raw", "logistic" and "cloglog".
\item For models trained with the \strong{Maxnet} method the argument \code{type} can
be: "link", "exponential", "logistic" and "cloglog", see
\code{\link[maxnet]{maxnet}} for more details.
}
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Train a model
model <- train(method = "Maxnet", data = data, fc = "l")

# Get the confusion matrix for thresholds ranging from 0 to 1
cm <- confMatrix(model, type = "cloglog")
head(cm)
tail(cm)

# Get the confusion matrix for a specific threshold
confMatrix(model, type = "logistic", th = 0.6)
}
\author{
Sergio Vignali
}
