% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPA.R
\name{plotPA}
\alias{plotPA}
\title{Plot Presence Absence Map}
\usage{
plotPA(
  map,
  th,
  colors = NULL,
  hr = FALSE,
  filename = "",
  overwrite = FALSE,
  wopt = list(),
  ...
)
}
\arguments{
\item{map}{\link[terra]{rast} object with the prediction.}

\item{th}{numeric. The threshold used to convert the output in a
presence/absence map.}

\item{colors}{vector. Colors to be used, default is \code{NULL} and it uses red
and blue.}

\item{hr}{logical. If \code{TRUE} it produces an output with high resolution.}

\item{filename}{character. If provided the raster map is saved in a file. It
must include the extension.}

\item{overwrite}{logical. If \code{TRUE} an existing file is overwritten.}

\item{wopt}{list. Writing options passed to \link[terra]{writeRaster}.}

\item{...}{Unused arguments.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Plot a presence absence map using the given threshold.
}
\examples{
\donttest{map <- terra::rast(matrix(runif(400, 0, 1),
                                    nrow = 20,
                                    ncol = 20))
plotPA(map,
       th = 0.8)

# Custom colors
plotPA(map,
       th = 0.5,
       colors = c("#d8b365", "#018571"))

\dontrun{
# Save the file. The following command will save the map in the working
# directory. Note that `filename` must include the extension.
plotPA(map,
       th = 0.7,
       filename = "my_map.tif")}}
}
\seealso{
\link{plotPred}.
}
\author{
Sergio Vignali
}
