% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getJ.R
\name{getJ}
\alias{getJ}
\title{getJ}
\usage{
getJ(N, bases = c(2, 3))
}
\arguments{
\item{N}{Population or frame size (a scalar)}

\item{bases}{A vector of co-prime Halton bases of length D.}
}
\value{
A vector of length 2 containing the exponents 
of bases that produce a Halton cycle of length B such 
that n <= B <= N.
}
\description{
Compute J, the depth of the Halton lattice, 
given a population size .
}
\details{
This routine returns a largest Halton cycle (i.e., B) 
such that n <= B <= N.  The first few Halton cycles are in 
Robertson et al. (2018) Web table 1.
}
\examples{

getJ(62208, c(2,3))  # should equal c(8,5)
getJ(72, c(2,3))  # should equal c(3,2)

}
\author{
Trent McDonald
}
