% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLattice.R
\name{plotLattice}
\alias{plotLattice}
\title{plotLattice}
\usage{
plotLattice(latt, indices = NULL, J = NULL, bases = c(2, 3), box = NULL, ...)
}
\arguments{
\item{latt}{A list containing the Halton boxes in the lattice. 
One item in the list for each Halton box.  Each list item is a 
2 X 2 matrix where first row is min and max of dimension 1, 
second row is min and max of dimension 2.}

\item{indices}{The halton indices of all boxes.  \code{length(latt)} must equal
\code{length(indices)} and \code{indices[i]} is the index of box \code{latt[[i]]}. 
If missing or NULL, indices are not printed.}

\item{J}{A 2X1 vector of base powers.  \code{J[1]} is for horizontal,
\code{J[2]} for vertical dimension. \code{J} determines the size and shape
of the smallest Halton boxes. There are \code{bases[1]^J[1]} vertical columns 
of Halton boxes over \code{x}'s bounding box, and \code{bases[2]^J[2]} 
horizontal rows of Halton boxes over the bounding box, for a total 
of \code{prod(bases^J)} boxes.  The dimension of each box is 
\code{c(dx,dy)/} \code{(bases^J)}, where \code{c(dx,dy)} are the horizontal and 
vertical extents of \code{x}'s bounding box.  If \code{J=NULL} (the default),
\code{J} is chosen so that Halton boxes are as square as possible.}

\item{bases}{2X1 vector of Halton bases.  These must be co-prime.}

\item{box}{The bounding box of all the halton boxes in \code{latt}. If missing
or NULL, the min and max extent of \code{latt} are used.}

\item{...}{Options of \code{graphics::lines} that control appearance of 
the boxes.  For example, 
\code{lty}, \code{col}, etc.}
}
\value{
NULL is returned invisibly.
}
\description{
Plot a Halton lattice
}
\details{
Lines on the current plot are produced.
}
\author{
Trent McDonald

  @examples 
lattice <- hip.lattice.polygon( box = matrix(c(0,0,1,1),2), J = c(2,2) bases = c(2,3) )
plotLattice(lattice)
}
