% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srs.point.r
\name{srs.point}
\alias{srs.point}
\title{Draw a Simple Random Sample (SRS) from a point resource or finite population frame.}
\usage{
srs.point(x, n)
}
\arguments{
\item{x}{A \code{SpatialLines}, \code{SpatialLinesDataFrame}, or \code{data.frame} object.}

\item{n}{Sample size.  Number of points or rows to draw from \code{x}. 
If \code{n} exceeds the number of units (= number of rows in \code{data.frame(x)}), 
a census is taken (i.e., \code{x} is returned).}
}
\value{
If input \code{x} inherits from a the \code{SpatialPoints} class, a
\code{SpatialPointsDataFrame} object containing locations and attributes in the sample is returned. 
If input \code{x} is a \code{data.frame}, a \code{data.frame} is returned. 
Attributes of the returned sample points are: 
\itemize{
  \item \code{sampleID}: A unique identifier for every sample point.  
  \code{sampleID} starts with 1 at the first point and 
  increments by one for each.  
  \item If \code{x} inherits from \code{SpatialPoints}, 
  returned points have attribute \code{geometryID} -- the ID (= \code{row.names(x)} ) of 
  the sampled point. 
  \item Any attributes (columns) associated with the input points (rows).
}
Additional attributes of the output object are:
\itemize{
   \item \code{frame}: Name of the input sampling frame (i.e., \code{x}).
   \item \code{frame.type}: Type of resource in sampling frame. (i.e., "point").
   \item \code{sample.type}: Type of sample drawn. (i.e., "SRS").
}
}
\description{
Draw a systematic sample from a \code{SpatialPoints*} object or a \code{data.frame}.   
\code{SpatialPoints*} objects can represent point resources in 2-dimensional space, such as towns, event locations, 
or grid cell centers.
}
\details{
When \code{x} is a data frame, the simple random sample is drawn from the rows.  That is, 
each row is viewed as a sample unit. 

This draws equi-probable sample.  First order inclusion probabilities are n/N for all units.
}
\examples{

# Draw systematic sample across range of population
WA.samp <- srs.point( WA.cities, 100 )   
plot( WA.cities )
points( WA.samp, col="red", pch=16 )

# Draw systematic sample from data frame
df <- data.frame( a=1:100, b=runif(100) )
samp <- srs.point( df, 5 )   

}
\seealso{
\code{\link{srs.polygon}}, \code{\link{srs.line}}, \code{\link{sdraw}}
}
\author{
Trent McDonald
}
\keyword{design}
\keyword{survey}
