% Generated by roxygen2 (4.0.2): do not edit by hand
\name{maxd}
\alias{maxd}
\title{Maximum Difference}
\usage{
maxd(x, o, g, n, d, s, ymax, xlab, color)
}
\arguments{
\item{x}{a column vector of scores on which the maximum difference is conditioned}

\item{o}{a column vector of equated scores based on the overall population (aligned with elements in x)}

\item{g}{column vectors of equated scores based on various subpopulations (aligned with elements in x)}

\item{n}{a scalar indicating the number of groups}

\item{d}{a scalar of the difference that matters}

\item{s}{a scalar representing the standard deviation of x for any (sub)population of interest (e.g., synthetic population) (default is 1, which leads to calculation of the unstandardized maxd)}

\item{ymax}{A maximum value for the y axis of the plot (default = 3 + the maximum maxD value)}

\item{xlab}{A label for the x axis of the plot (default = Score Scale)}

\item{color}{color of maxD line and points on plot (default = red)}
}
\value{
A data frame of maximum difference indices, conditioned on the score scale

A plot of the maximum difference indices in reference to the difference that matters
}
\description{
The maximum difference index, \eqn{MAXD}{MAXD}, locates the maximum absolute difference between conditional subpopulation equated scores, \eqn{y_j(x)}{y_j(x)}, and the equated scores based on the overall population, \eqn{y(x)}{y(x)}. Formally,
\deqn{MAXD=\frac{\mbox{max}\lbrack\mid y_j(x)-y(x)\mid\rbrack}{\sigma_x},}{EMAXD=max[|y_j(x)-y(x)|]/s,}
where \eqn{x}{x} is a score on the original (i.e., not equated) scale and \eqn{\sigma_x}{s} is the standard deviation of \eqn{x}{x} scores in the (sub)population of interest. It is considered an omnibus, conditional index. It was originally presented by Dorans and Holland (2000). It provides practitioners with the maximum difference found between any one subpopulation's equated scores and the equated scores based on the overall population, at each level of the original scale.

}
\examples{
#Unstandardized MAXD across subpopulation 1 and subpopulation 2 in the example data set, ex.data
maxd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4]),
n=2,d=.5)

#Unstandardized MAXD across subpopulations 1 thru 5 in the example data set, ex.data
maxd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4],ex.data[,5],ex.data[,6],ex.data[,7]),
n=5,d=.5)

#Standardized MAXD across subpopulations 1 thru 5 in the example data set, ex.data
maxd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4],ex.data[,5],ex.data[,6],ex.data[,7]),
n=5,d=.5,s=4.2)
}
\author{
Anne Corinne Huggins-Manley
}
\references{
\itemize{
\item{Dorans, N.J., & Holland, P.W. (2000). Population invariance and the equitability of tests: Theory and the linear case. Journal of Educational Measurement, 37, 281-306.}
}
}
\seealso{
\code{\link{emaxd}}
}

