% Generated by roxygen2 (4.0.2): do not edit by hand
\name{remsd}
\alias{remsd}
\title{Root Expected Mean Square Difference}
\usage{
remsd(x, o, g, f, s, w)
}
\arguments{
\item{x}{a column vector of scores on which the rmsd is conditioned}

\item{o}{a column vector of equated scores based on the overall population (aligned with elements in x)}

\item{g}{column vectors of equated scores based on various subpopulations (aligned with elements in x)}

\item{f}{a column vector of relative frequency associated with each raw score (can be based on either overall population or a subpopulation) (aligned with elements in x)}

\item{s}{a scalar representing the standard deviation of x for any (sub)population of interest (e.g., synthetic population) (default is 1, which leads to calculation of the unstandardized remsd)}

\item{w}{A row vector of weights for subpopulations 1 thru n (length = number of groups)}
}
\value{
root expected mean square difference
}
\description{
The root expected mean square difference index (\eqn{REMSD}{REMSD}) is a summary index of the weighted differences between each subpopulation equated score, \eqn{y_j(x)}{y_j(x)}, and the equated score based on the overall population, \eqn{y(x)}{y(x)}. Formally, 
\deqn{REMSD=\frac{\sqrt{\sum_x P_x \{\sum_j w_j\lbrack y_j(x)-y(x)\rbrack^2\}}}{\sigma_x,}}{REMSD=sqrt(sum(P\{sum(w_j[y_j(x)-y(x)]^2\})))/s,}
where \eqn{w_j}{w_j} is a subpopulation weight, \eqn{x}{x} is a score on the original (i.e., unequated) scale, \eqn{P_x}{P} is the proportion of examinees scoring at \eqn{x}{x} and \eqn{\sigma_x}{s} is the standard deviation of \eqn{x}{x} scores in the (sub)population of interest. It is considered an omnibus, unconditional index. It was originally presented by Dorans and Holland (2000).  It provides practitioners with a summary of the magnitude of weighted differences between subpopulation equated scores and equated scores based on the overall population.
}
\note{
The equally weighted version of this index (Kolen & Brennan, 2004) can be obtained by inputting a \eqn{w}{w} vector consisting of identical elements that sum to 1. See example 1 below.
}
\examples{
#Unstandardized REMSD for subpopulations 1 and 2 in the example data set, ex.data, 
#assuming equal weights for the subpopulations
remsd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4]),f=ex.data[,8],w=c(.5,.5))

#Unstandardized REMSD for all five subpopulations in the example data set, ex.data
remsd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4],ex.data[,5],ex.data[,6],ex.data[,7]),
f=ex.data[,8],w=c(.1,.2,.4,.2,.1))

#Standardized REMSD for all five subpopulations in the example data set, ex.data
remsd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4],ex.data[,5],ex.data[,6],ex.data[,7]),
f=ex.data[,8],w=c(.1,.2,.4,.2,.1),s=4.2)
}
\author{
Anne Corinne Huggins-Manley
}
\references{
\itemize{
\item{Dorans, N.J., & Holland, P.W. (2000). Population invariance and the equitability of tests: Theory and the linear case. Journal of Educational Measurement, 37, 281-306.}
}
}
\seealso{
\code{\link{rmsd}}
}

