% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rmsd}
\alias{rmsd}
\title{Root Mean Square Difference}
\usage{
rmsd(x, o, g, w, d, s, ymax, xlab, color)
}
\arguments{
\item{x}{a column vector of scores on which the rmsd is conditioned}

\item{o}{a column vector of equated scores based on the overall population (aligned with elements in x)}

\item{g}{column vectors of equated scores based on various subpopulations (aligned with elements in x)}

\item{w}{a row vector of weights for subpopulations 1 thru n (length = number of groups)}

\item{d}{a scalar of the difference that matters}

\item{s}{a scalar representing the standard deviation of x for any (sub)population of interest (e.g., synthetic population) (default is 1, which leads to calculation of the unstandardized rmsd)}

\item{ymax}{A maximum value for the y axis of the RMSD graph (default = 3 + the maximum RMSD value)}

\item{xlab}{A label for the x axis of the RMSD graph (default = Score Scale)}

\item{color}{color of RMSD line and points on plot (default = red)}
}
\value{
A data frame of RMSD indices, conditioned on the score scale

A plot of the RMSD in reference to the difference that matters
}
\description{
The root mean square difference index (\eqn{RMSD}{RMSD}) is a conditional index of the weighted differences between each subpopulation equated score, \eqn{y_j(x)}{y_j(x)}, and the equated score based on the overall population, \eqn{y(x)}{y(x)}. Formally, 
\deqn{RMSD=\frac{\sqrt{\sum_j w_j\lbrack y_j(x)-y(x)\rbrack^2}}{\sigma_x},}{RMSD=sqrt(sum(w_j[y_j(x)-y(x)]^2)))/s,}
where \eqn{w_j}{w_j} is a subpopulation weight, \eqn{x}{x} is a score on the original (i.e., unequated) scale, and \eqn{\sigma_x}{s} is the standard deviation of \eqn{x}{x} scores in the (sub)population of interest. It is considered an omnibus, conditional index. It was originally presented by Dorans and Holland (2000). It provides practitioners with the magnitude of weighted differences between subpopulation equated scores and equated scores based on the overall population.
}
\note{
The equally weighted version of this index (Kolen & Brennan, 2004) can be obtained by inputting a \eqn{w}{w} vector consisting of identical elements that sum to 1. See example 1 below.
}
\examples{
#Unstandardized RMSD for subpopulations 1 and 2 in the example data set, ex.data, 
#assuming equal weights for the subpopulations
rmsd(x=ex.data[,1],o=ex.data[,2],g=c(ex.data[,3],ex.data[,4]),w=c(.5,.5),d=.5)

#Unstandardized RMSD for all five subpopulations in the example data set, ex.data
rmsd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4],ex.data[,5],ex.data[,6],ex.data[,7]),
w=c(.1,.2,.4,.2,.1),d=.5)

#Unstandardized RMSD for all five subpopulations in the example data set, ex.data, 
#with adjustments to the maximum y-axis on the plot, a new xlabel, 
#and points/line in blue
rmsd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4],ex.data[,5],ex.data[,6],ex.data[,7]),
w=c(.1,.2,.4,.2,.1),d=.5,ymax=3,xlab="Old Form",color="blue")

#Standardized RMSD for all five subpopulations in the example data set, ex.data
rmsd(x=ex.data[,1],o=ex.data[,2],
g=c(ex.data[,3],ex.data[,4],ex.data[,5],ex.data[,6],ex.data[,7]),
w=c(.1,.2,.4,.2,.1),d=.5,s=4.2)
}
\author{
Anne Corinne Huggins-Manley
}
\references{
\itemize{
\item{Dorans, N.J., & Holland, P.W. (2000). Population invariance and the equitability of tests: Theory and the linear case. Journal of Educational Measurement, 37, 281-306.}
}
}
\seealso{
\code{\link{remsd}}
}

