% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Landscape-Methods.R
\name{simulateLandscape}
\alias{simulateLandscape}
\title{function simulateLandscape

Create an object \code{Landscape}. Simulate a landscape with neutral and source fields and receptors margins.}
\usage{
simulateLandscape(n = 500, prop = 0.4, range = 10, xmin = 0,
  xmax = 5000, ymin = 0, ymax = 5000, border_size = 200,
  prob = runif(1, 0.1, 0.9), mean_thickness = runif(1, 2, 20),
  v_thickness = 50)
}
\arguments{
\item{n}{Numeric, numbers of fields}

\item{prop}{Numeric [0,1] toxic fields proportion}

\item{range}{truc}

\item{xmin}{x left coordinates}

\item{xmax}{x right coordinates}

\item{ymin}{y top coordinates}

\item{ymax}{y bottom coordinates}

\item{border_size}{A numeric, bbox margin}

\item{prob}{Probability to inflated a border}

\item{mean_thickness}{Border width expectation}

\item{v_thickness}{Border width variance}
}
\value{
An S4 \code{Landscape} object with n fields, prop pourcentage of toxic fields of size (xmin,xmax) (ymin,ymax)
}
\description{
function simulateLandscape

Create an object \code{Landscape}. Simulate a landscape with neutral and source fields and receptors margins.
}
\examples{
\dontrun{ simulateLandscape(100,0.4,10,0,1000,0,1000,100,runif(1,0.1,0.9),runif(1,2,20),50) }
}

