% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgewiseID.R
\name{edgewiseID}
\alias{edgewiseID}
\title{Determines which edges in a mixed graph are edgewiseID-identifiable}
\usage{
edgewiseID(mixedGraph, tianDecompose = T, subsetSizeControl = 3)
}
\arguments{
\item{mixedGraph}{a \code{\link{MixedGraph}} object representing the L-SEM.}

\item{tianDecompose}{TRUE or FALSE determining whether or not the Tian
decomposition should be used before running the
current generic identification algorithm. In general
letting this be TRUE will make the algorithm faster and
more powerful.}

\item{subsetSizeControl}{a positive integer (Inf allowed) which controls
the size of edgesets searched in the edgewiseID
algorithm. Suppose, for example, this has value 3.
Then if a node i has n parents, this will restrict
the algorithm to only look at subsets of the parents
of size 1,2,3 and n-2, n-1, n. Making this
parameter smaller means the algorithm will be faster
but less exhaustive (and hence less powerful).}
}
\value{
see the return of \code{\link{generalGenericID}}.
}
\description{
Uses the edgewise identification criterion of Weihs, Robeva, Robinson, et al.
(2017) to determine which edges in a mixed graph are generically
identifiable.
}
