% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsToEllipsoid.R
\name{pointsToEllipsoid}
\alias{pointsToEllipsoid}
\title{Test whether a set of points are inside or outside a defined ellipse}
\usage{
pointsToEllipsoid(X, Sigma, mu)
}
\arguments{
\item{X}{the \code{i x d} matrix of data points to be transformed}

\item{Sigma}{the \code{d x d} covariance matrix of the ellipsoid}

\item{mu}{the vector of means of the ellipse of length \code{d}}
}
\value{
A matrix of transformed data points corresponding to \code{X}
}
\description{
Takes a \code{i x d} matrix of points where \code{d} is the dimension of the 
space considered, and \code{i} is the number of points and returns 
\code{TRUE} or \code{FALSE} for whether each point is inside or outside a 
d-dimensional ellipsoid defined by a covariance matrix \code{Sigma} and 
vector of means \code{mu}.
}
\examples{
X <- matrix(runif(200,-2.5, 2.5), ncol = 2, nrow = 100)
SIG <- matrix(c(1,0,0,1), ncol = 2, nrow = 2)
mu <- c(0, 0)
Z <- pointsToEllipsoid(X, SIG, mu)
test <- ellipseInOut(Z, p = 0.95)
plot(X, col = test + 1, xlim = c(-3, 3), ylim = c(-3, 3), asp = 1)
addEllipse(mu, SIG, p.interval = 0.95)

}
