% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LF.R
\name{LF}
\alias{LF}
\title{Inference for linear combination of the regression vector in high dimensional
generalized linear regression}
\usage{
LF(
  X,
  y,
  loading.mat,
  model = c("linear", "logistic", "logistic_alter"),
  intercept = TRUE,
  intercept.loading = FALSE,
  beta.init = NULL,
  lambda = NULL,
  mu = NULL,
  prob.filter = 0.05,
  rescale = 1.1,
  alpha = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{X}{Design matrix, of dimension \eqn{n} x \eqn{p}}

\item{y}{Outcome vector, of length \eqn{n}}

\item{loading.mat}{Loading matrix, nrow=\eqn{p}, each column corresponds to a
loading of interest}

\item{model}{The high dimensional regression model, either \code{"linear"}
or \code{"logistic"} or \code{"logistic_alter"}}

\item{intercept}{Should intercept be fitted for the initial estimator
(default = \code{TRUE})}

\item{intercept.loading}{Should intercept term be included for the loading
(default = \code{FALSE})}

\item{beta.init}{The initial estimator of the regression vector (default =
\code{NULL})}

\item{lambda}{The tuning parameter in fitting initial model. If \code{NULL},
it will be picked by cross-validation. (default = \code{NULL})}

\item{mu}{The dual tuning parameter used in the construction of the
projection direction. If \code{NULL} it will be searched automatically.
(default = \code{NULL})}

\item{prob.filter}{The threshold of estimated probabilities for filtering
observations in logistic regression. (default = 0.05)}

\item{rescale}{The factor to enlarge the standard error to account for the
finite sample bias. (default = 1.1)}

\item{alpha}{Level of significance to construct two-sided confidence interval
(default = 0.05)}

\item{verbose}{Should intermediate message(s) be printed, the projection
direction be returned. (default = \code{FALSE})}
}
\value{
\item{est.plugin.vec}{The vector of plugin(biased) estimators for the
linear combination of regression coefficients, length of
\code{ncol(loading.mat)}; each corresponding to a loading of interest}
\item{est.debias.vec}{The vector of bias-corrected estimators for the linear
combination of regression coefficients, length of \code{ncol(loading.mat)};
each corresponding to a loading of interest}
\item{se.vec}{The vector of standard errors of the bias-corrected estimators,
length of \code{ncol(loading.mat)}; each corresponding to a loading of interest}
\item{ci.mat}{The matrix of two.sided confidence interval for the linear
combination, of dimension \code{ncol(loading.mat)} x \eqn{2}; each row
corresponding to a loading of interest}
\item{proj.mat}{The matrix of projection directions; each column corresponding
to a loading of interest. It will be returned only if \code{verbose} set as TRUE}
}
\description{
Inference for linear combination of the regression vector in high dimensional
generalized linear regression
}
\examples{
X = matrix(rnorm(100*5), nrow=100, ncol=5)
y = -0.5 + X[,1] * 0.5 + X[,2] * 1 + rnorm(100)
loading1 = c(1, 1, rep(0, 3))
loading2 = c(-0.5, -1, rep(0, 3))
loading.mat = cbind(loading1, loading2)
Est = LF(X, y, loading.mat, model="linear")

## compute confidence intervals
ci(Est, alpha=0.05, alternative="two.sided")

## summary statistics
summary(Est)
}
