% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.meta.survival.R
\name{calculate.meta.survival}
\alias{calculate.meta.survival}
\title{Fit a meta-analytic Cox proportional hazards model to a single feature}
\usage{
calculate.meta.survival(
  feature.name,
  expression.data,
  survival.data,
  rounding = 3,
  other.data = NULL,
  data.type.ordinal = FALSE,
  centre.data = "median"
)
}
\arguments{
\item{feature.name}{Character indicate what feature (gene/probe/etc.) should
be extracted for analysis}

\item{expression.data}{A list where each component is an expression matrix
(patients = columns, genes = rows) for a different dataset}

\item{survival.data}{A list where each component is an object of class Surv}

\item{rounding}{How many digits after the decimal place to include}

\item{other.data}{A list of other covariates to be passed to the Cox model
(all elements in this list are used}

\item{data.type.ordinal}{Logical indicating whether to treat this datatype
as ordinal. Defaults to FALSE}

\item{centre.data}{A character string specifying the centre value to be used for 
scaling data. Valid values are: 'median', 'mean', or a user defined numeric threshold
e.g. '0.3' when modelling methylation beta values. This value is used for both scaling
as well as for dichotomising data for estimating univariate betas from Cox model.
Defaults to 'median'}
}
\value{
Returns a vector containing the HR, p-value, n, and 95\% confidence
limits of the HR (see fit.coxmodel() for details)
}
\description{
Takes a meta-analysis data object and fits a Cox proportional hazards model
(possibly with adjustment for some specific covariates) by
median-dichotomizing patients within each individual dataset.
}
\examples{

data.directory <- get.program.defaults()[["test.data.dir"]];
data.types <- c("mRNA");
x1 <- load.cancer.datasets(
  datasets.to.load = c('Breastdata1'),
  data.types = data.types,
  data.directory = data.directory
  );
x2 <- calculate.meta.survival(
  feature.name = "1000_at",
  expression.data = x1$all.data[[data.types[1]]],
  survival.data = x1$all.survobj
  );

}
\author{
Paul C. Boutros
}
\keyword{survival}
