% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getLocation}
\alias{getLocation}
\title{Get the colony location}
\usage{
getLocation(x)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}
}
\value{
numeric with two values when \code{x} is \code{\link{Colony-class}}
  and a list of numeric with two values when \code{x} is
  \code{\link{MultiColony-class}} (list named after colonies); \code{c(NA, NA)}
  when location not set
}
\description{
Level 0 function that returns the colony location as (x, y)
  coordinates.
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])

getLocation(colony)
getLocation(apiary[[1]])
getLocation(apiary)

loc <- c(123, 456)
colony <- setLocation(colony, location = loc)
getLocation(colony)

loc1 <- c(512, 722)
colony1 <- setLocation(apiary[[1]], location = loc1)
getLocation(colony1)

loc2 <- c(189, 357)
colony2 <- setLocation(apiary[[2]], location = loc2)
getLocation(colony2)

getLocation(c(colony1, colony2))

# Assuming one location (as in bringing colonies to an apiary at a location!)
apiary <- setLocation(apiary, location = loc1)
getLocation(apiary)

# Assuming different locations (so tmp is not an apiary in one location!)
tmp <- setLocation(c(colony1, colony2), location = list(loc1, loc2))
getLocation(tmp)
}
