% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sipd_conflicts.R
\name{sipd_conflicts}
\alias{sipd_conflicts}
\title{Indicate conflicts of the packages inside SIPDIBGE}
\usage{
sipd_conflicts(survey = NULL)
}
\arguments{
\item{survey}{Name of the household survey for reference package information. If \code{NULL}, presents the information of all the packages inside this collection.}
}
\value{
A vector with conflits of functions of the packages inside SIPDIBGE.
}
\description{
This function describes conflicts between functions of the packages inside SIPDIBGE and another installed packages.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
sipd_conflicts()
# Presenting information about the PNADcIBGE package
sipd_conflicts(survey="PNADC")
# Presenting information about the POFIBGE package
sipd_conflicts(survey="POF")
# Presenting information about the PNSIBGE package
sipd_conflicts(survey="PNS")
# Presenting information about the COVIDIBGE package
sipd_conflicts(survey="COVID")}
}
\seealso{
\link[SIPDIBGE]{sipd_deps} for indicating dependencies of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_logo} for showing logos of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_packages} for indicating the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_sitrep} for indicating version informations for the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_update} for indicating the existance of an update for the packages inside SIPDIBGE.
}
