% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sipd_update.R
\name{sipd_update}
\alias{sipd_update}
\title{Indicate version updates of the packages inside SIPDIBGE}
\usage{
sipd_update(survey = NULL)
}
\arguments{
\item{survey}{Name of the household survey for reference package information. If \code{NULL}, presents the information of all the packages inside this collection.}
}
\value{
A vector with version updates of the packages inside SIPDIBGE.
}
\description{
This function describes version updates of the packages inside SIPDIBGE.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
sipd_update()
# Presenting information about the PNADcIBGE package
sipd_update(survey="PNADC")
# Presenting information about the POFIBGE package
sipd_update(survey="POF")
# Presenting information about the PNSIBGE package
sipd_update(survey="PNS")
# Presenting information about the COVIDIBGE package
sipd_update(survey="COVID")}
}
\seealso{
\link[SIPDIBGE]{sipd_conflicts} for indicating conflicts of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_deps} for indicating dependencies of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_logo} for showing logos of the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_packages} for indicating the packages inside SIPDIBGE.\cr \link[SIPDIBGE]{sipd_sitrep} for indicating version informations for the packages inside SIPDIBGE.
}
