% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qSIP_MAGs.R
\name{tax.table}
\alias{tax.table}
\title{phyloseq taxa table from GTDB taxonomy input}
\usage{
tax.table(taxonomy)
}
\arguments{
\item{taxonomy}{GTDB taxonomy data frame.  A taxonomy file in the GTDB output format. Load the bacteria and archaea taxonomy outputs separately.
The markdown requires loading the standard output files from GTDB-Tk separately for bacteria and archaea}
}
\value{
phyloseq-style taxonomy table, but for MAGs
}
\description{
A MAG table, similar to OTU table in phyloseq, will be generated from a
concantenated GTDB taxa table for bacteria and archaea
}
\examples{
data(taxonomy_tibble)

\donttest{

### Making phyloseq table from taxonomy metadata
taxonomy.object = tax.table(taxonomy_tibble)
}

}
