% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{GTFSstop_times}
\alias{GTFSstop_times}
\title{GTFS stop_times table relevant to SIRI sample}
\format{A data frame with 153021 observations on the following 8 variables:
\describe{
   \item{trip_id}{An ID that identifies a trip.}
   \item{arrival_time}{The arrival time at a specific stop for a specific trip on a route. }
   \item{departure_time}{The departure time from a specific stop for a specific trip on a route.}
   \item{stop_id}{An ID that uniquely identifies a stop. Multiple routes may use the same stop. }
   \item{stop_sequence}{The order of the stops for a particular trip. }
   \item{pickup_type}{Indicates whether passengers are picked up at a stop as part of the normal schedule or whether a pickup at the stop is not available. 0 for Regularly scheduled pickup, 1 for No pickup available}
   \item{drop_off_type}{Indicates whether passengers are dropped off at a stop as part of the normal schedule or whether a drop off at the stop is not available. 0 for Regularly scheduled drop off, 1 for No drop off available.}
   \item{shape_dist_traveled}{The distance from the first shape point.}
}}
\source{
\url{https://developers.google.com/transit/gtfs/reference/#stop_timestxt}
}
\usage{
GTFSstop_times
}
\description{
Subset of the GTFS stop_times table for Israel for the SIRIsample data.
This is only a small subset of the Israeli GTFS stop_times table, extracted to be used with the SIRIsample data.
it shows the stop times data for the SIRIsample data.
note that GTFS is a global standard and not all operators fill all of the columns.
}
\keyword{datasets}
