% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NearestStop.R
\name{NearestStop}
\alias{NearestStop}
\title{Find the nearest stop to each SIRI SpatialPoint}
\usage{
NearestStop(SIRIspdf, Stopsspdf)
}
\arguments{
\item{SIRIspdf}{The SIRI spatialPointsDataFrame}

\item{Stopsspdf}{GTFS Stops spatialPointsDataFrame}
}
\value{
Adds a column containing the Nearest stop to each observation in the SIRI \code{\link[sp]{SpatialPointsDataFrame}}
}
\description{
Finds the nearest stop to each SIRI SpatialPoint in the SIRI SpatialPointsDataFrame.
Requires both the SIRI SpatialPointsDataFrame and the GTFS stops SpatialPointsDataFrame.
}
\details{
Returns the SIRI \code{\link[sp]{SpatialPointsDataFrame}} with an extra column stating which GTFS stops is closest to each observation.
The function is a part of STG and should not be used on it's own.
}
\section{Warning}{

Do Not use this function on it's own, it is meant to be used only as part of the STG process
}

\references{
Bogin, D., Levy, N. and Ben-Elia E. (2018) \emph{Estimation of Public Transportation Service Reliability Using Big Data and Open Source Tools}
}
\seealso{
\code{\link[SIRItoGTFS]{STG}}
}
\keyword{internal}
\keyword{misc}
