% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SFCB.R
\name{sfcb}
\alias{sfcb}
\title{SFCB}
\usage{
sfcb(
  X,
  Y,
  group.method = c("adjclust", "cclustofvar"),
  summary.method = c("pls", "basics", "cclustofvar"),
  selection.method = c("none", "boruta", "relief"),
  at = round(0.15 * ncol(X)),
  range.at = NULL,
  seed = NULL,
  repeats = 5,
  keep.time = TRUE,
  verbose = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{X}{input predictors (matrix or data.frame)}

\item{Y}{target variable (vector whose length is equal to the number of rows
in X)}

\item{group.method}{group method. Default to \code{"adjclust"}}

\item{summary.method}{summary method. Default to \code{"pls"}}

\item{selection.method}{selection method. Default to \code{"none"} (no 
selection performed)}

\item{at}{number of groups targeted for output results (integer). Not used
when \code{range.at} is not \code{NULL}}

\item{range.at}{(vector of integer) sequence of the numbers of groups for
output results}

\item{seed}{random seed (integer)}

\item{repeats}{number of repeats for the final random forest computation}

\item{keep.time}{keep computational times for each step of the method? 
(logical; default to \code{TRUE})}

\item{verbose}{print messages? (logical; default to \code{TRUE})}

\item{parallel}{not implemented yet}
}
\value{
an object of class \code{"SFCB"} with elements: 
  \item{dendro}{a dendrogram corresponding to the method chosen in
  \code{group.method}}
  \item{groups}{a list of length \code{length(range.at)} (or of length 1 if
  \code{range.at == NULL}) that contains the clusterings of input variables
  for the selected group numbers}
  \item{summaries}{a list of the same length than \code{$groups} that 
  contains the summarized predictors according to the method chosen in 
  \code{summary.methods}}
  \item{selected}{a list of the same length than \code{$groups} that contains
  the names of the variable selected by \code{selection.method} if it is not
  equal to \code{"none"}}
  \item{mse}{a data.frame with \code{repeats} \eqn{\times}
  \code{length($groups)} rows that contains Mean Squared Errors of the 
  \code{repeats} random forests fitted for each number of groups}
  \item{importance}{a list of the same length than \code{$groups} that 
  contains a data.frame providing variable importances for the variables in
  selected groups in \code{repeats} columns (one for each iteration of the
  random forest method). When \code{summary.method == "basics"}, importance 
  for mean and sd are provided in separated columns, in which case, the 
  number of columns is equal to 2\code{repeats}}
  \item{computational.times}{a vector with 4 values corresponding to the
  computational times of (respectively) the group, summary, selection, and RF
  steps. Only if \code{keep.time == TRUE}}
  \item{call}{function call}
}
\description{
\code{SFCB} performs interval selection based on random forests
}
\examples{
data(truffles)
out1 <- sfcb(rainfall, truffles, group.method = "adjclust", 
             summary.method = "pls", selection.method = "relief")
out2 <- sfcb(rainfall, truffles, group.method = "adjclust", 
             summary.method = "basics", selection.method = "none",
             range.at = c(5, 7))
}
\author{
{Remi Servien, \email{remi.servien@inrae.fr}\cr
Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}}
}
