% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcb_methods.R
\name{SFCB-class}
\alias{SFCB-class}
\alias{summary.SFCB}
\alias{print.SFCB}
\alias{plot.SFCB}
\alias{extract_at.SFCB}
\alias{quality.SFCB}
\alias{extract_at}
\alias{quality}
\title{Methods for SFCB objects}
\usage{
\method{summary}{SFCB}(object, ...)

\method{print}{SFCB}(x, ...)

\method{plot}{SFCB}(
  x,
  ...,
  plot.type = c("dendrogram", "selection", "importance", "quality"),
  sel.type = c("importance", "selection"),
  threshold = "none",
  shape.imp = c("boxplot", "histogram"),
  quality.crit = "mse"
)

extract_at(object, at)

quality(object, ground_truth, threshold = NULL)
}
\arguments{
\item{object}{a \code{SFCB} object}

\item{...}{not used}

\item{x}{a \code{SFCB} object}

\item{plot.type}{type of the plot. Default to \code{"dendrogram"} (see
Details)}

\item{sel.type}{when \code{plot.type == "selection"}, criterion on which to
base the selection. Default to \code{"importance"}}

\item{threshold}{numeric value. If not \code{NULL}, selection of variables to
compute qualities is based on a threshold of importance values
\code{extract_at}}

\item{shape.imp}{when \code{plot.type == "importance"}, type of plot to
represent the importance. Default to \code{"boxplot"}}

\item{quality.crit}{character vector (length 1 or 2) indicating one or two
quality criteria to display. The values have to be taken in \{\code{"mse"},
\code{"time"}, \code{"Precision"}, \code{"Recall"}, \code{"ARI"}, 
\code{"NMI"}\}. If \code{"time"} is chosen, it can not be associated with any
other criterion}

\item{at}{numeric vector. Set of the number of intervals to extract for}

\item{ground_truth}{numeric vector of ground truth. Target variables 
to compute qualities correspond to non-zero entries of this vector}
}
\description{
Print, plot, manipulate or compute quality for outputs of the
\code{\link{sfcb}} function (\code{SFCB} object)
}
\details{
The \code{plot} functions can be used in four different ways to 
extract information from the \code{SFCB} object: \itemize{
 \item \code{plot.type == "dendrogram"} displays the dendrogram obtained at
 the clustering step of the method. Depending on the cases, the dendrogram
 comes with additional information on clusters, variable selections and/or
 importance values;
 \item \code{plot.type == "selection"} displays either the evolution of the
 importance for the simulation with the best (smallest) MSE for each time
 step in the range of the functional predictor or the evolution of the
 selected intervals along the whole range of the functional prediction also 
 for the best MSE;
 \item \code{plot.type == "importance"} displays a summary of the importance
 values over the whole range of the functional predictor and for the 
 different experiments. This summary can take the form of a boxplot or of
 an histogram;
 \item \code{plot.type == "quality"} displays one or two quality distribution
 with respect to the different experiments and different number of intervals.
}
}
\examples{
data(truffles)
out1 <- sfcb(rainfall, truffles, group.method = "adjclust", 
             summary.method = "pls", selection.method = "relief")
summary(out1)

\dontrun{
plot(out1)
plot(out1, plot.type = "selection")
plot(out1, plot.type = "importance")
}

out2 <- sfcb(rainfall, truffles, group.method = "adjclust", 
             summary.method = "basics", selection.method = "none",
             range.at = c(5, 7))
out3 <- extract_at(out2, at = 6)
summary(out3)

}
\references{
{Servien, R. and Vialaneix, N. (2023) A random forest approach 
for interval selection in functional regression. Preprint.}
}
\seealso{
\code{\link{sfcb}}
}
\author{
{Remi Servien, \email{remi.servien@inrae.fr}\cr
Nathalie Vialaneix, \email{nathalie.vialaneix@inrae.fr}}
}
