% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lambda.sel.R
\name{Lambda.sel}
\alias{Lambda.sel}
\title{Select the Penalty Parameter of LASSO-type Linear Regression}
\usage{
Lambda.sel(X, y, newX, newY, family = "gaussian", alpha = 1)
}
\arguments{
\item{X}{Matrix of predictors of the estimation sample.}

\item{y}{Dependent variables of the estimation sample.}

\item{newX}{Design matrix in the forecasting subsample.}

\item{newY}{Dependent variable in the forecasting subsample.}

\item{family}{Response type. See the glmnet command in R. Possible types are "gaussian", "binomial",
"poisson", "multinomial", "cox", "mgaussian". Default is "gaussian".}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0 \leq \alpha \leq 1}. See the glmnet command in R. Default value is 1.}
}
\value{
A list containing:
\itemize{
   \item lambda.min - lambda that achieves the minimum mean square error.
   \item beta - estimated coefficients for lambda.min.
   \item mse - mean squared error.
   \item lambda - the actual sequence of lambda values used.
}
}
\description{
Use out-of-sample Root Mean Square Error to select the penalty parameter of
LASSO-type linear regression.
}
\examples{
X <- cbind(rnorm(200),rnorm(200,2,1),rnorm(200,4,1))
y <- rnorm(200)
newX <- cbind(rnorm(200),rnorm(200,2,1),rnorm(200,4,1))
newy <- rnorm(200)
output <- Lambda.sel(X, y, newX, newy)
}
