% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLOPE_solver.R
\name{SLOPE_solver_matlab}
\alias{SLOPE_solver_matlab}
\title{Interface to MATLAB sorted L1 solver}
\usage{
SLOPE_solver_matlab(A, b, lambda, initial = numeric(), matlab = NULL)
}
\arguments{
\item{A}{an \eqn{n}-by-\eqn{p} matrix}

\item{b}{vector of length \eqn{n}}

\item{lambda}{vector of length \eqn{p}, sorted in decreasing order}

\item{initial}{initial guess for \eqn{x}}

\item{matlab}{MATLAB client object (instance of class \code{Matlab}).
If supplied, the client object should be connected to a running MATLAB
server. If not supplied, a MATLAB server will be started (requires 'matlab'
to be on the PATH).}
}
\value{
The solution vector \eqn{x}.
}
\description{
Uses the \code{R.matlab} package to invoke the TFOCS sorted L1 solver.
See \code{\link{SLOPE_solver}} for a description of the sorted L1
optimization problem.
}
\seealso{
\code{\link{SLOPE_solver}}
}
\keyword{internal}

