% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.smle}
\alias{predict.smle}
\alias{predict.selection}
\title{Prediction based on SMLE screening and selection}
\usage{
\method{predict}{smle}(object, newdata = NULL, type = c("link", "response", "terms"), ...)

\method{predict}{selection}(object, newdata = NULL, type = c("link", "response", "terms"), ...)
}
\arguments{
\item{object}{A \code{'smle'} or \code{'selection'} object.}

\item{newdata}{Matrix of new values for the features at which predictions are to be made. If omitted, the fitted linear predictors are used.}

\item{type}{The type of prediction required by \code{\link[stats]{predict.glm}()}.}

\item{...}{Further arguments passed to \code{\link[stats]{predict.glm}()}.}
}
\value{
A prediction vector with length equal to the number of rows of \code{newdata}.
}
\description{
For a model object of class \code{'smle'} or \code{'selection'}, this function returns the predicted response values after re-fitting the model using \code{\link{glm}}.
}
\examples{

set.seed(1)
Data_sim <- Gen_Data(n = 420, p = 1000, sigma = 0.5, family = "gaussian")
train_X <- Data_sim$X[1:400,]; test_X <- Data_sim$X[401:420,]
train_Y <- Data_sim$Y[1:400]; test_Y <- Data_sim$Y[401:420]
fit1 <- SMLE(Y = train_Y, X = train_X, family = "gaussian", k = 10)

#Fitted responses vs true responses in training data
predict(fit1)[1:10]
train_Y[1:10]

#Predicted responses vs true responses in testing data
predict(fit1, newdata = test_X)
test_Y



}
