% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastphase.R
\name{SNPknock.fp.runFastPhase}
\alias{SNPknock.fp.runFastPhase}
\title{Calls fastPhase to fit an HMM to genotype data.}
\usage{
SNPknock.fp.runFastPhase(fp_path, X_file, out_path = NULL, K = 12,
  numit = 25, seed = 1)
}
\arguments{
\item{fp_path}{a string with the path to the directory with the fastPhase executable.}

\item{X_file}{a string with the path of the genotype input file containing X in fastPhase
format (as created by \link{SNPknock.fp.writeX}).}

\item{out_path}{a string with the path of the directory in which the parameter estimates 
will be saved (default: NULL). If this is equal to NULL, a temporary file 
in the R temporary directory will be used.}

\item{K}{the number of hidden states for each haplotype sequence (default: 12).}

\item{numit}{the number of EM iterations (default: 25).}

\item{seed}{the random seed for the EM algorithm (default: 1).}
}
\value{
A string containing the path of the directory in which the parameter estimates 
        were saved. This is useful to find the data when the default option for `out_path` 
        is used and the output is written in an R temporary directory.
}
\description{
This function provides a wrapper for the fastPhase executable in order to fit an HMM to the
genotype data. The software fastPhase will fit the HMM  to the genotype data and write the 
corresponding parameter estimates in three separate files. 
Since fastPhase is not an R package, this executable must be downloaded separately by the 
user. Visit \url{http://scheet.org/software.html} for more information on how to obtain fastPhase.
}
\details{
The software fastPhase saves the parameter estimates in three separate files whose names
begin with the string contained in 'out_path' and end with:
\itemize{
  \item{"_rhat.txt"}
  \item{"_alphahat.txt"}
  \item{"_thetahat.txt"}
}

The HMM for the genotype data can then be loaded from these files by calling
\link{SNPknock.fp.loadFit}.
}
\examples{
fp_path  = "~/.local/bin/fastPHASE" # Path to the fastPHASE executable
# Specify the path to the genotype input file in ".inp" format.
# An example file can be found in the package installation folder.
X_file = system.file("extdata", "X.inp", package = "SNPknock")
fp_outPath = SNPknock.fp.runFastPhase(fp_path, X_file)

}
\references{
Scheet and Stephens,  A fast and flexible statistical model for large-scale population genotype data,
  Am J Hum Genet (2006).
  \href{http://www.sciencedirect.com/science/article/pii/S000292970763701X}{http://www.sciencedirect.com/science/article/pii/S000292970763701X}
}
\seealso{
Other fastphase: \code{\link{SNPknock.fp.loadFit}},
  \code{\link{SNPknock.fp.writeX}}
}
