% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knockoffs.R
\name{SNPknock.knockoffDMC}
\alias{SNPknock.knockoffDMC}
\title{Knockoff copies of a discrete Markov chain}
\usage{
SNPknock.knockoffDMC(X, pInit, Q, seed = 123, cluster = NULL,
  display_progress = TRUE)
}
\arguments{
\item{X}{an integer matrix of size n-by-p containing the original variables.}

\item{pInit}{an array of length K, containing the marginal distribution of the states for the first variable.}

\item{Q}{an array of size (p-1,K,K), containing a list of p-1 transition matrices between the K states of the Markov chain.}

\item{seed}{an integer random seed (default: 123).}

\item{cluster}{a computing cluster object created by \link[parallel]{makeCluster} (default: NULL).}

\item{display_progress}{whether to show progress bar (default: TRUE).}
}
\value{
An integer matrix of size n-by-p containing the knockoff variables.
}
\description{
This function constructs knockoff copies of variables distributed as a discrete Markov chain.
}
\details{
Each element of the matrix X should be an integer value between 0 and K-1.
The transition matrices contained in Q are defined such that \eqn{P[X_{j+1}=k|X_{j}=l]=Q[j,l,k]}.
}
\examples{
p=10; K=5;
pInit = rep(1/K,K)
Q = array(stats::runif((p-1)*K*K),c(p-1,K,K))
for(j in 1:(p-1)) { Q[j,,] = Q[j,,] / rowSums(Q[j,,]) }
X = SNPknock.models.sampleDMC(pInit, Q, n=20)
Xk = SNPknock.knockoffDMC(X, pInit, Q)

}
\references{
Sesia et al., Gene Hunting with Knockoffs for Hidden Markov Models,
  arXiv:1706.04677 (2017).
  \href{https://statweb.stanford.edu/~candes/papers/HMM_Knockoffs.pdf}{https://statweb.stanford.edu/~candes/papers/HMM_Knockoffs.pdf}
}
\seealso{
Other knockoffs: \code{\link{SNPknock.knockoffGenotypes}},
  \code{\link{SNPknock.knockoffHMM}},
  \code{\link{SNPknock.knockoffHaplotypes}}
}
