\name{SNSequate-package}
\alias{SNSequate-package}
\alias{SNSequate}
\docType{package}
\title{Standard and Nonstandard Statistical Models and Methods for Test
Equating
}

\description{The package contains functions to perform various models and 
	methods for test equating. It currently implements the traditional 
	mean, linear and equipercentile equating methods, as well as the 
	mean-mean, mean-sigma, Haebara and Stocking-Lord IRT linking methods. 
	It also supports newest methods such that local equating, kernel 
	equating (using Gaussian, logistic and uniform kernels), and IRT 
	parameterlinking methods based on asymmetric item characteristic 
	functions. Functions to obtain both standard error of equating (SEE) 
	and standard error of equating difference between two equating 
	functions (SEED) are also implmented for the kernel method of 
	equating.
}

\details{
\tabular{ll}{
Package: \tab SNSequate\cr
Type: \tab Package\cr
Version: \tab 1.1-0\cr
Date: \tab 2013-10-10\cr
License: \tab GPL (>= 2)\cr
}
}

\author{Jorge Gonzalez Burgos

Maintainer: Jorge Gonzalez Burgos <jgonzale@mat.puc.cl>

}

\references{

	Estay, G. (2012). \emph{Characteristic Curves Scale Transformation Methods Using 
	Asymmetric ICCs for IRT Equating}. Unpublished MSc. Thesis. Pontificia Universidad 
	Catolica de Chile.

	Gonzalez, J. (2013). Statistical Models and Inference for the True Equating Transformation in the 
	Context of Local Equating. \emph{Journal of Educational Measurement, 50(3),} 315-320.
	
	Holland, P. and Thayer, D. (1989). The kernel method of equating score distributions. 
	(Technical Report No 89-84). Princeton, NJ: Educational Testing Service.

	Holland, P., King, B. and Thayer, D. (1989). The standard error of equating for the kernel method 
	of equating score distributions (Tech. Rep. No. 89-83). Princeton, NJ: Educational Testing Service. 

	Kolen, M., and Brennan, R. (2004). \emph{Test Equating, Scaling and Linking}. 
	New York, NY: Springer-Verlag.

	Lord, F. (1980). \emph{Applications of Item Response Theory to Practical Testing Problems}. 
	Lawrence Erlbaum Associates, Hillsdale, NJ.

	Lord, F. and Wingersky, M. (1984). Comparison of IRT True-Score and Equipercentile Observed-Score Equatings. 
	\emph{Applied Psychological Measurement,8(4),} 453--461.

	van der Linden, W. (2011). Local Observed-Score Equating. In A. von Davier (Ed.) 
	\emph{Statistical Models for Test Equating, Scaling, and Linking}. New York, NY: Springer-Verlag.

	van der Linden, W. (2013). Some Conceptual Issues in Observed-Score Equating. 
	\emph{Journal of Educational Measurement, 50(3),} 249-285.

	Von Davier, A., Holland, P., and Thayer, D. (2004). \emph{The Kernel Method of Test Equating}. 
	New York, NY: Springer-Verlag.
}


\keyword{ package }

